(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6325,        181]*)
(*NotebookOutlinePosition[      7053,        206]*)
(*  CellTagsIndexPosition[      7009,        202]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(Needs["\<Graphics`Arrow`\>"];\)\ \ \  (*\ 
      para\ dibujar\ vectores\ *) \), "\n", 
    \(\(Needs["\<Graphics`Colors`\>"];\)\  (*\ 
      para\ usar\ colores\ con\ comodidad\ *) \), "\n", 
    \(\(vector[w_] := 
        Graphics[{Red, \ Arrow[{0, 0}, {Re[w], Im[w]}]}, \ 
          Axes -> True, \ \ AspectRatio -> 1, \ 
          AxesLabel -> {"\<Re\>", "\<Im\>"}];\)\), "\n", 
    \(\(linea[w1_, w2_] := 
        Graphics[{Green, \ Line[{{Re[w1], Im[w1]}, {Re[w2], Im[w2]}}]}, 
          Axes -> Automatic, \ \ AspectRatio -> 1, \ 
          AxesLabel -> {"\<Re\>", "\<Im\>"}];\)\)}], "Input"],

Cell[BoxData[
    \(\(suma[z_, w_] := 
        Show[vector[z], vector[w], 
          Graphics[{Blue, \ Arrow[{0, 0}, {Re[z + w], Im[z + w]}]}], 
          linea[z, z + w], linea[z + w, w]];\)\)], "Input"],

Cell[BoxData[
    \(\(prod[z_, w_] := 
        Show[vector[z], vector[w], 
          Graphics[{Blue, \ 
              Arrow[{0, 0}, {Re[z*w], Im[z*w]}]}]];\)\)], "Input"],

Cell[BoxData[
    \(\(suma[1 + I, 3 + I];\)\)], "Input"],

Cell[BoxData[
    \(\(prod[1 + I, 2 + I];\)\)], "Input"],

Cell[BoxData[
    \(Simplify[\(-\[Pi]\)/2 < ArcTan[x] < \[Pi]/2, 
      x \[Element] Reals]\)], "Input"],

Cell[BoxData[
    \(Simplify[ArcTan[x] \[GreaterEqual] \[Pi]/2, 
      x \[Element] Reals]\)], "Input"],

Cell[BoxData[
    \(Arg[\(-1\) + I]\)], "Input"],

Cell[BoxData[
    \(Simplify[\(-\[Pi]\) < Arg[z] \[LessEqual] \[Pi]]\)], "Input"],

Cell[BoxData[
    \(Simplify[Arg[z] \[LessEqual] \(-\[Pi]\)]\)], "Input"],

Cell[BoxData[
    \(Simplify[Arg[z] > \[Pi]]\)], "Input"],

Cell[BoxData[
    \(sol[
        k_] := \(\(z /. 
          Solve[z^k \[Equal] 1, z]\)\(//\)\(ComplexExpand\)\(\ \ \)\( (*\ 
          una\ lista\ con\ las\ ra\[IAcute]ces\ k - \[EAcute]simas\ de\ 1\ en\
\ forma\ cartesiana\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(sol[6]\)], "Input"],

Cell[BoxData[
    \(\(\(args[k_]\)\(:=\)\(Sort[Arg[sol[k]], Less]\)\(\ \ \ \)\( (*\ 
        ordena\ por\ argumentos\ crecientes\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(args[6]\)], "Input"],

Cell[BoxData[
    \(puntos[k_] := \(\(\({Cos[#], Sin[#]} &\)\  /@ args\ [k]\)\(\ \)\( (*\ 
        paso\ a\ coordenadas\ cartesianas\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(flechas[k_] := \(Arrow[{0, 0}, #] &\) /@ puntos[k];\)\( (*\ 
      representa\ las\ ra\[IAcute]ces\ por\ vectores\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(flechas[5]\)], "Input"],

Cell[BoxData[
    \(\(\(\(poligono[k_] := 
        Show[Graphics[{Line[Append[puntos[k], First[puntos[k]]]], flechas[k], 
              Circle[{0, 0}, 1]}], AspectRatio \[Rule] 1]\) \)\(;\)\( (*\ 
      pol\[IAcute]gono\ regular\ de\ k\ lados\ inscrito\ en\ la\ \
circunferencia\ unidad\ con\ las\ flechas\ *) \)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(poligono[5];\)\)], "Input"],

Cell[BoxData[
    \(sol[
        k_] := \(\(z\)\(/.\)\(NSolve[z^k \[Equal] 1, z]\)\(\ \ \)\( (*\ 
          una\ lista\ con\ las\ ra\[IAcute]ces\ k - \[EAcute]simas\ de\ 1\ *) \
\)\)\)], "Input"],

Cell[BoxData[{
    \(Do[poligono[k], {k, 3, 15}]\), "\[IndentingNewLine]", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[BoxData[{
    \(nuevospuntos[
        k_] := \(Chop[#] &\) /@ \((\({Cos[#], 
                Sin[#]} &\) /@ \((2 \((Range[k + 1] - 1)\) 
                N[\[Pi]]/k)\))\)\), "\[IndentingNewLine]", 
    \(\(nuevasflechas[k_] := \(Arrow[{0, 0}, #] &\) /@ 
          nuevospuntos[k];\)\), "\[IndentingNewLine]", 
    \(\(nuevopoligono[k_] := 
        Show[Graphics[{Line[nuevospuntos[k]], Hue[ .25], nuevasflechas[k], 
              Hue[ .65], Circle[{0, 0}, 1], 
              Join[{Hue[0], PointSize[ .025], Point[{0, 0}]}, 
                Point /@ nuevospuntos[k]]}], 
          AspectRatio \[Rule] 1];\)\)}], "Input"],

Cell[BoxData[{
    \(Do[nuevopoligono[k], {k, 3, 15}]\), "\[IndentingNewLine]", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(\(FrontEndTokenExecute["\<OpenCloseGroup\>"];\)\)}], "Input"],

Cell[BoxData[{
    \(v = Cos[2  \[Pi]/33. ] + I\ Sin[2  \[Pi]/33. ];  (*\ 
      la\ "\<primera\>"\ ra\[IAcute]z\ de\ orden\ 33\ de\ z = 
        1\ *) \[IndentingNewLine]Do[
      Show[vector[v^k], 
        PlotRange \[Rule] {{\(-1.1\), 1.1}, {\(-1.1\), 1.1}}], {k, 1, 
        33}];\), "\[IndentingNewLine]", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1019, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 622, 12, 202, "Input"],
Cell[2379, 65, 204, 4, 124, "Input"],
Cell[2586, 71, 170, 4, 98, "Input"],
Cell[2759, 77, 56, 1, 72, "Input"],
Cell[2818, 80, 56, 1, 72, "Input"],
Cell[2877, 83, 104, 2, 72, "Input"],
Cell[2984, 87, 103, 2, 72, "Input"],
Cell[3090, 91, 48, 1, 72, "Input"],
Cell[3141, 94, 81, 1, 72, "Input"],
Cell[3225, 97, 73, 1, 72, "Input"],
Cell[3301, 100, 57, 1, 72, "Input"],
Cell[3361, 103, 245, 5, 98, "Input"],
Cell[3609, 110, 39, 1, 72, "Input"],
Cell[3651, 113, 150, 2, 72, "Input"],
Cell[3804, 117, 40, 1, 72, "Input"],
Cell[3847, 120, 154, 2, 94, "Input"],
Cell[4004, 124, 159, 2, 120, "Input"],
Cell[4166, 128, 43, 1, 72, "Input"],
Cell[4212, 131, 333, 5, 176, "Input"],
Cell[4548, 138, 49, 1, 72, "Input"],
Cell[4600, 141, 195, 4, 72, "Input"],
Cell[4798, 147, 215, 3, 124, "Input"],
Cell[5016, 152, 623, 12, 250, "Input"],
Cell[5642, 166, 225, 3, 146, "Input"],
Cell[5870, 171, 451, 8, 172, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

